using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.BO;
using VIRP.EFR.DAL;
using VIRP.EFR.DAL.Imaging.Utility;
using VIRP.EFR.UTIL;

namespace VIRP.EFR.BLL
{
    public static partial class STD_UNITSManager
    {
        #region Fields
        #endregion

        #region Properties
        #endregion

        #region Methods

        public static STD_UNITS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            STD_UNITS objReturn = null;
            STD_UNITSDB objDB = new STD_UNITSDB();

            objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, ID);

            return objReturn;
        }

        public static List<STD_UNITS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_UNITS> objReturn = null;
            STD_UNITSDB objDB = new STD_UNITSDB();

            objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static List<KeyValuePair<int, string>> GetActiveOrderedTestUnits(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            string cacheKey = new CacheKey().AddPart("GetActiveOrderedTestUnits").Build();

            return CacheHelper.GetAdd(cacheKey, 
                () =>
                {
                    var db = new STD_UNITSDB();

                    var units = db.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID)
                    .Where(u => u.INACTIVE_FLAG == false)
                    .OrderBy(u => u.SORT_ORDER)
                    .Select(u => new KeyValuePair<int, string>(u.ID, u.NAME))
                    .ToList();

                    return units;
                });
        }

        public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_UNITS objSave)
        {
            Int32 objReturn = 0;
            STD_UNITSDB objDB = new STD_UNITSDB();

            objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            Boolean objReturn = false;
            STD_UNITSDB objDB = new STD_UNITSDB();

            objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_UNITS objDelete)
        {
            return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.ID);
        }

        #endregion
    }
}
